import { View, FlatList, Text } from "react-native";
import React from "react";
import styles from "./VendorReviewsStyle";
import BackNavigation from "../../Utilities/CustomHeader/BackNavigation";
import ItemSeparator from "../../Utilities/ItemSeparator/ItemSeparator";
import ProductReviewsItem from "../../../src/components/ProductReviewsItem/ProductReviewsItem";
import AverageReviews from "../../../src/components/Vendor/VendorReviews/AverageReviews/AverageReviews";
import CustomerGallery from "../../../src/components/Vendor/VendorReviews/CustomerGallery/CustomerGallery";
import ReviewsProgessbar from "../../../src/components/Vendor/VendorReviews/ReviewsProgessbar/ReviewsProgessbar";
import CustomActiveIndicator from "../../../src/components/CustomLoader/CustomActiveIndicator";
import { getVendorProductReviews } from "../../../redux/slices/vendor/vendorProfile";
import { useSelector, useDispatch } from "react-redux";
import useLangTranslation from "../../../hooks/useLangTranslation";

const VendorReviews = (props) => {
	const { trans } = useLangTranslation();
	const dispatch = useDispatch();
	const { vendorProductReviews, vendorProfileInfo, nextPageUrl, loading, loadMore } = useSelector(
        (state) => state.vendorProfile
	);

	const { avg, reviewCount, progessBarRating  } = vendorProfileInfo || {};

	const handleMoreData = () => {
        let isMounted = true;
        if (isMounted && nextPageUrl && !loadMore) {
            dispatch(getVendorProductReviews(nextPageUrl));
        }
        return () => {
            isMounted = false;
        };
	};

	return (
		<>
			<BackNavigation
				navigationProps={props.navigation}
				routeName={trans("Vendor Reviews")}
				capitalize={true}
			/>
			<>
				<View style={styles.container}>
					<FlatList
						data={vendorProductReviews}
						renderItem={({ item }) => <ProductReviewsItem item={item} />}
						keyExtractor={(item) => "c" + item.id.toString()}
						ItemSeparatorComponent={() => <ItemSeparator />}
						showsVerticalScrollIndicator={false}
						windowSize={10}
						onEndReachedThreshold={1}
                        onEndReached={handleMoreData}
						ListHeaderComponent={
							<>
								<AverageReviews review={{avg: avg, reviewCount: reviewCount }} />
								<ReviewsProgessbar progessBarRating={ progessBarRating } />
								<CustomerGallery vendorProductReviews={vendorProductReviews} />
								<View style={styles.header}>
									<Text style={styles.title}>{trans("Feedbacks")}</Text>
									<Text style={styles.title}>({reviewCount})</Text>
								</View>
							</>
						}
						ListFooterComponent={<View style={styles.listFooter} />}
					/>
				</View>
				{loadMore && <CustomActiveIndicator />}
			</>
		</>
	);
};

export default VendorReviews;
